package gov.va.med.mhv.rxrefill.data.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name = "MESSAGE_TRACE_LOG")
public class MessageTraceLog implements Serializable {

	private static final long serialVersionUID = -1995615031180684621L;

	@Id
	@Column(name = "MESSAGE_TRACE_LOG_ID_SEQ")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Column(name = "OPLOCK")
	private Integer oplock = 1;

	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;

	@Column(name = "MESSAGE_TYPE")
	private String messageType;

	@Column(name = "MESSAGE")
	private String message;

	@Column(name = "MESSAGE_DIRECTION")
	private String messageDirection;

	@Column(name = "PATIENT_ID")
	private String patientId;


	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public String getMessageType() {
		return messageType;
	}

	public void setMessageType(String messageType) {
		this.messageType = messageType;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public String getMessageDirection() {
		return messageDirection;
	}

	public void setMessageDirection(String messageDirection) {
		this.messageDirection = messageDirection;
	}

	public String getPatientId() {
		return patientId;
	}

	public void setPatientId(String patientId) {
		this.patientId = patientId;
	}

	public String toString() {
		StringBuffer sb = new StringBuffer();

		sb.append("id : " + id);
		sb.append(System.getProperty("line.separator"));
		sb.append(", oplock : " + oplock);
		sb.append(System.getProperty("line.separator"));
		sb.append(", createdDate : " + createdDate);
		sb.append(System.getProperty("line.separator"));
		sb.append(", messageType : " + messageType);
		sb.append(System.getProperty("line.separator"));
		sb.append(", message : " + message);
		sb.append(System.getProperty("line.separator"));
		sb.append(", messageDirection : " + messageDirection);
		sb.append(System.getProperty("line.separator"));
		sb.append(", patientId : " + patientId);
		sb.append(System.getProperty("line.separator"));

		return sb.toString();
	}

}
